% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_TAG.R
\name{plotTAG}
\alias{plotTAG}
\title{Main Effects Plots from a TAG Process}
\usage{
plotTAG(object, include.legend = TRUE, legend.position = "bottomright")
}
\arguments{
\item{object}{object of class inheriting from "TAG".}

\item{include.legend}{logical value indicating if the legend of the main effects plot is required.}

\item{legend.position}{a character indicating the position of the legend.}
}
\description{
This function produces the main effects plot from a TAG process.
}

\details{
The location of the legend is "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", or "center".
}

\value{
A main effects plot in the transformed scale of the response is returned.
}
\references{
Lin, L.-H. and Joseph,  V. R. (2019+) "Transformation and Additivity in Gaussian Processes", \emph{Technometrics, to appear}.  DOI:10.1080/00401706.2019.1665592.
}
\seealso{
  \code{\link{TAG}} for finding estimates for the parameters in a TAG process.
}
\examples{
n <- 20
p <- 2
library(randtoolbox)
X <-  sobol(n, dim = p, init = TRUE, scrambling = 2, seed = 20, normal = FALSE)
y <- exp(2*sin(0.5*pi*X[,1]) + 0.5*cos(2.5*pi*X[,2]))
ini.TAG <- initial.TAG(y, X)
par.TAG <- TAG(ini.TAG)
plotTAG(par.TAG)
}
\keyword{Main Effect Plots}
\keyword{TAG}
\keyword{TAAG}
