% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatorDTSD.R
\name{generatorDTSD}
\alias{generatorDTSD}
\title{Instantiate the an object of class Dynamic Time Series Data (DTSD)}
\usage{
generatorDTSD(dataset,
periodindex,
IDindex,
timeindex,
statusindex,
variable,
ifclassifydata=TRUE,
predict.time=365,
isfill=TRUE
)
}
\arguments{
\item{dataset}{A dataframe of time-series observations, containing identification numbers of each subject, index of time slice, value of risk factors, survival time, and survival outcomes.}

\item{periodindex}{Time slice indicator, represent index of time slice of specific observation, This variable is normally coded by integers, e.g. 0, 1, 2...}

\item{IDindex}{Variable name representing patient identification number.}

\item{timeindex}{Variable name representing follow up time for censored data for each specific observation.}

\item{statusindex}{The status indicator representing the patient's outcome status. For Overall survival, the status is normally coded by the policy 0=alive, 1=dead.}

\item{variable}{List object containing the risk factors required for modeling.}

\item{ifclassifydata}{A logical value, which is optional. Judgment on whether to classify risk factors automatically. When \code{ifclassifydata} is \code{TRUE} (default is TRUE), survivalROC method is used to find cutoff to dichotomize risk factors.}

\item{predict.time}{Optional, Time of event assessment for identifying the best cutoff using survivalROC. When \code{ifclassifydata} is \code{TRUE}, \code{predict.time} is used in combination.}

\item{isfill}{Logical value, used to confirm whether to fill in missing data. If it is True, then fill.}
}
\value{
return a DTSD class object for survivalpath() function.
\item{time}{\code{time} list object; Event time or censoring time for subjects.Each element of the list represents, the event time or censoring time starting from each observation}
\item{status}{\code{status} list object; Indicator of status,normally use 0/1 coding. If death or event,1,otherwise,0. Each element of the list represents, the subject's outcome/event.}
\item{tsdata}{\code{tsdata} list object; Each element of \code{tsdata} contains the risk factors listed in \code{variable}. Each element of the list represents the data frame of each time slice, normally arranged in ascending order}
\item{tsid}{\code{tsid} list object; patient identification number. Each element of the list represents,the identification number of patient at each time slice}
\item{length}{  \code{time},\code{status},\code{tsdata} ,\code{tsid} are the same length \code{length}.}
\item{ts_size}{List object, representing sample size at each time slice.}
\item{cutoff}{ List object, representing cut-off values for each variable used for modeling.}
}
\description{
Generate DTSD class objects using a dataframe. The dataframe should include unique identification number for each subject, multiple
rows arranged data (contain risk factors, survival time and outcomes) representing observations at different time slices/time points.
}
\details{
This function return a DTSD class object for conducting survivalpath function. This function facilitate enabling automatic binary classification of
continuous variables. When continuous variables need to be classified, survivalROC uses survival data at the predict.time to calculate cutoffs. The cutoff will
be used for construction of survival path at all time slices.
}
\examples{
library(dplyr)
data("DTSDHCC")
id = DTSDHCC$ID[!duplicated(DTSDHCC$ID)]
set.seed(123)
id = sample(id,500)
miniDTSDHCC <- DTSDHCC[DTSDHCC$ID \%in\% id,]
dataset = timedivision(miniDTSDHCC,"ID","Date",period = 90,left_interval = 0.5,right_interval=0.5)
resu <- generatorDTSD(dataset,periodindex="time_slice",IDindex="ID" ,timeindex="OStime_day",
 statusindex="Status_of_death",variable =c( "Age", "Amount.of.Hepatic.Lesions",
 "Largest.Diameter.of.Hepatic.Lesions",
 "New.Lesion","Vascular.Invasion" ,"Local.Lymph.Node.Metastasis",
 "Distant.Metastasis" , "Child_pugh_score" ,"AFP"),predict.time=365*1)

}
