% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boosting_function.R
\name{boosting_core}
\alias{boosting_core}
\title{Boosting core function}
\usage{
boosting_core(formula, data, rate, control = 500,
  control_method = NULL, control_parameter = NULL,
  censoring_type = "right")
}
\arguments{
\item{formula}{a formula object with a response value using the Surv
function.}

\item{data}{a data.frame containing all variables specified in the formula.}

\item{rate}{the desired update rate used in the boosting algorithm.}

\item{control}{an integer used as the number of iterations of the boosting
algorithm. Default value is 500.}

\item{control_method}{specifies stopping method, options include: cv,
num_selected, likelihood, BIC, AIC. Default is NULL, which will use a fixed
number of iterations as specified by control.}

\item{control_parameter}{provides the parameter needed for each corresponding
control_method option.}

\item{censoring_type}{currently only right censoring is implemented.}
}
\value{
a list containing the vector of coefficients (beta), variable
  selection matrix that contains the coefficients at each iteration
  (selection_df), the number of boosting iterations (mstop), and other
  stopping criteria if applicable to selected method.
}
\description{
This function allows you to use gradient boosting for variable selection.
}
\examples{
data <- simulate_survival_cox(true_beta=c(1,1,1,1,1,0,0,0,0,0))
formula <- as.formula("Surv(time,delta) ~ strata(strata_idx) + V1 + V2 + 
V3 + V4 + V5 + V6 + V7 + V8 + V9 + V10" )
boosting_core(formula, data, rate=0.1, control=500)
boosting_core(formula, data, rate=0.1, control_method="num_selected", control_parameter=5)

}
\keyword{boosting}
\keyword{gradient}
