% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald-LS.R
\name{Wald.BNLS}
\alias{Wald.BNLS}
\title{Wald Test via Least Squares.}
\usage{
Wald.BNLS(t, s, X, is_zero)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Model matrix.}

\item{is_zero}{Logical vector, with as many entires as columns in the target model
matrix, indicating which columns have coefficient zero under the null.}
}
\value{
A numeric vector containing the Wald statistic, the degrees of
  freedom, and a p-value.
}
\description{
Performs a Wald test of the null hypothesis that a subset of the regression
parameters for the target outcome are zero.
}
\examples{
\donttest{
# Generate data.
set.seed(100)
n <- 1e3
X <- cbind(1, rnorm(n))
data <- rBNR(X = X, Z = X, b = c(1, 0), a = c(-1, 0), t_miss = 0.1, s_miss = 0.0)

# Test 1st coefficient.
wald_test1 <- Wald.BNLS(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  is_zero = c(TRUE, FALSE)
)

# Test 2nd coefficient.
wald_test2 <- Wald.BNLS(
  t = data[, 1], 
  s = data[, 2], 
  X = X, 
  is_zero = c(FALSE, TRUE)
)
}
}
