% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvCont.R
\name{print.MetaAnalyticSurvCont}
\alias{print.MetaAnalyticSurvCont}
\title{Prints all the elements of an object fitted with the 'MetaAnalyticSurvCont()' function.}
\usage{
\method{print}{MetaAnalyticSurvCont}(x, ...)
}
\arguments{
\item{x}{An object of class 'MetaAnalyticSurvCont' fitted with the 'MetaAnalyticSurvCont()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals and the estimated treatment effect on the surrogate and true endpoint.
}
\description{
Prints all the elements of an object fitted with the 'MetaAnalyticSurvCont()' function.
}
\examples{
\dontrun{
data("colorectal4")
data("prostate")
fit <- MetaAnalyticSurvCont(data = prostate, true = SURVTIME, trueind = SURVIND, surrog = PSA,
trt = TREAT, center = TRIAL, trial = TRIAL, patientid = PATID,
copula = "Hougaard", adjustment = "weighted")
print(fit)
}
}
