% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_ContCont_copula.R
\name{fit_copula_ContCont}
\alias{fit_copula_ContCont}
\title{Fit continuous-continuous vine copula model}
\usage{
fit_copula_ContCont(
  data,
  copula_family,
  marginal_S0,
  marginal_S1,
  marginal_T0,
  marginal_T1,
  start_copula,
  method = "BFGS",
  ...
)
}
\arguments{
\item{data}{data frame with three columns in the following order: surrogate
endpoint, true endpoint, and treatment indicator (0/1 coding). Ordinal endpoints
should be integers starting from \code{1}.}

\item{copula_family}{One of the following parametric copula families:
\code{"clayton"}, \code{"frank"}, \code{"gaussian"}, or \code{"gumbel"}. The first element in
\code{copula_family} corresponds to the control group, the second to the
experimental group.}

\item{marginal_S0, marginal_S1, marginal_T0, marginal_T1}{List with the
following three elements (in order):
\itemize{
\item Density function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Distribution function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Inverse distribution function with first argument \code{p} and second argument \code{para} the parameter
vector for this distribution.
\item The number of elements in \code{para}.
\item A vector of starting values for \code{para}.
}}

\item{start_copula}{Starting value for the copula parameter.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGS"}.}

\item{...}{Extra argument to pass onto maxLik::maxLik}
}
\value{
Returns an S3 object that can be used to perform the sensitivity
analysis with \code{\link[=sensitivity_analysis_copula]{sensitivity_analysis_copula()}}.
}
\description{
\code{\link[=fit_copula_ContCont]{fit_copula_ContCont()}} fits the continuous-continuous vine copula model. See
Details for more information about this model.
}
\seealso{
\code{\link[=sensitivity_analysis_copula]{sensitivity_analysis_copula()}}, \code{\link[=print.vine_copula_fit]{print.vine_copula_fit()}},
\code{\link[=plot.vine_copula_fit]{plot.vine_copula_fit()}}
}
\author{
Florian Stijven
}
