% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit_SurvSurv.R
\name{mean_S_before_T_plot_scr}
\alias{mean_S_before_T_plot_scr}
\alias{prob_dying_without_progression_plot}
\title{Goodness of fit plot for the fitted copula}
\usage{
mean_S_before_T_plot_scr(fitted_model, plot_method = NULL, grid, treated, ...)

prob_dying_without_progression_plot(
  fitted_model,
  plot_method = NULL,
  grid,
  treated,
  ...
)
}
\arguments{
\item{fitted_model}{Returned value from \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. This object
essentially contains the estimated identifiable part of the joint
distribution for the potential outcomes.}

\item{plot_method}{Defaults to \code{NULL}. Should not be modified.}

\item{grid}{Grid of time-points at which the model-based estimated regression
functions, survival functions, or probabilities are evaluated.}

\item{treated}{(numeric) Treatment group. Should be \code{0} or \code{1}.}

\item{...}{Additional arguments to pass to \code{\link[=plot]{plot()}}.}
}
\value{
\code{NULL}
}
\description{
The \code{\link[=mean_S_before_T_plot_scr]{mean_S_before_T_plot_scr()}} and \code{\link[=prob_dying_without_progression_plot]{prob_dying_without_progression_plot()}}
functions build plots to assess the goodness-of-fit of the copula model
fitted by \code{\link[=fit_model_SurvSurv]{fit_model_SurvSurv()}}. Specifically, these two functions focus on
the appropriateness of the copula. Note that to assess the appropriateness of
the marginal functions, two other functions are available:
\code{\link[=marginal_gof_scr_S_plot]{marginal_gof_scr_S_plot()}} and \code{\link[=marginal_gof_scr_T_plot]{marginal_gof_scr_T_plot()}}.
}
\section{Progression Before Death}{
If a patient progresses before death, this means that \eqn{S_k < T_k}. For
these patients, we can look at the expected progression time given that the
patient has died at \eqn{T_k = t}: \deqn{E(S_k | T_k = t, S_k < T_k).} The
\code{\link[=mean_S_before_T_plot_scr]{mean_S_before_T_plot_scr()}} function plots the model-based estimate of this
regression function together with a non-parametric estimate.

This regression function can also be estimated non-parametrically by
regressing \eqn{S_k} onto \eqn{T_k} in the subset of uncensored patients.
This non-parametric estimate is obtained via \code{mgcv::gam(y~s(x))} with
additionally \code{family = stats::quasi(link = "log", variance = "mu")} because
this tends to describe survival data better. The 95\% confidence intervals are
added for this non-parametric estimate; although, they should be interpreted
with caution because the Poisson mean-variance relation may be wrong.
}

\section{Death Before Progression}{
If a patient dies before progressing, this means that \eqn{S_k = T_k}. This
probability can be modeled as a function of time, i.e., \deqn{	\pi_k(t) =
P(S_k = t  \, | \, T_k = t).} The \code{\link[=prob_dying_without_progression_plot]{prob_dying_without_progression_plot()}}
function plots the model-based estimate of this regression function together
with a non-parametric estimate.

This regression function can also be estimated non-parametrically by
regressing the censoring indicator for \eqn{S_k}, \eqn{\delta_{S_k}},
onto \eqn{T_k} in the subset of patients with uncensored \eqn{T_k}.
}

\examples{
# Load Ovarian data
data("Ovarian")
# Recode the Ovarian data in the semi-competing risks format.
data_scr = data.frame(
  ttp = Ovarian$Pfs,
  os = Ovarian$Surv,
  treat = Ovarian$Treat,
  ttp_ind = ifelse(
    Ovarian$Pfs == Ovarian$Surv &
      Ovarian$SurvInd == 1,
    0,
    Ovarian$PfsInd
  ),
  os_ind = Ovarian$SurvInd
)
# Fit copula model.
fitted_model = fit_model_SurvSurv(data = data_scr,
                                  copula_family = "clayton",
                                  n_knots = 1)
# Define grid for GoF plots.
grid = seq(from = 1e-3,
           to = 2.5,
           length.out = 30)
# Assess marginal goodness-of-fit in the control group.
marginal_gof_scr_S_plot(fitted_model, grid = grid, treated = 0)
marginal_gof_scr_T_plot(fitted_model, grid = grid, treated = 0)
# Assess goodness-of-fit of the association structure, i.e., the copula.
prob_dying_without_progression_plot(fitted_model, grid = grid, treated = 0)
mean_S_before_T_plot_scr(fitted_model, grid = grid, treated = 0)
}
