% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonReconstruction.R
\name{PoissonReconstruction}
\alias{PoissonReconstruction}
\title{Poisson surface reconstruction}
\usage{
PoissonReconstruction(
  points,
  normals = NULL,
  spacing = NULL,
  sm_angle = 20,
  sm_radius = 30,
  sm_distance = 0.375
)
}
\arguments{
\item{points}{numeric matrix which stores the points, one point per row}

\item{normals}{numeric matrix which stores the normals, one normal per row
(it must have the same size as the \code{points} matrix); if you don't
have normals, set \code{normals=NULL} (the default) and some normals will
be computed with the help of \code{\link[Rvcg]{vcgUpdateNormals}}, or
use the \code{\link{getSomeNormals}} function}

\item{spacing}{size parameter; smaller values increase the precision of the
output mesh at the cost of higher computation time; set to \code{NULL}
(the default) for a reasonable automatic value: an average spacing whose
value will be displayed in a message and that you can also get in the
\code{"spacing"} attribute of the output}

\item{sm_angle}{bound for the minimum facet angle in degrees}

\item{sm_radius}{relative bound for the radius of the surface Delaunay balls}

\item{sm_distance}{relative bound for the center-center distances}
}
\value{
A triangle mesh, of class \code{mesh3d} (ready for plotting
  with \strong{rgl}).
}
\description{
Poisson reconstruction of a surface, from a cloud of 3D points.
}
\details{
See \href{https://doc.cgal.org/latest/Poisson_surface_reconstruction_3/index.html}{Poisson Surface Reconstruction}.
}
\examples{
library(SurfaceReconstruction)
library(rgl)

# Solid Möbius strip 
Psr_mesh <- PoissonReconstruction(SolidMobiusStrip)
shade3d(Psr_mesh, color= "yellow")
wire3d(Psr_mesh, color = "black")

# Hopf torus
Psr_mesh <- PoissonReconstruction(HopfTorus, spacing = 0.2)
shade3d(Psr_mesh, color= "darkorange")
wire3d(Psr_mesh, color = "black")
}
