% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sra.R
\name{plot.sra}
\alias{plot.sra}
\title{Plot sequential rank agreement}
\usage{
\method{plot}{sra}(
  x,
  xlim,
  ylim,
  xlab = "List depth",
  ylab = "Sequential rank agreement",
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{Agreement object}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{xlab}{x-axis lab}

\item{ylab}{y-axis lab}

\item{add}{Logical. If \code{TRUE} add graph to existing plot.}

\item{...}{Processed by function \code{prodlim::SmartControl}.}
}
\value{
Graph
}
\description{
Plot the agreement between lists as a function of the list depth
}
\examples{
R1=c(1,2,3,4,5,7,6,8,9,10,11,12,13)
R2=c(5,11,4,7,8,3,12,13,6,10,9,2,1)
a <- sra(list(R1,R2))
plot(a)
arand = colMeans(do.call("rbind",lapply(1:20,function(b){
    sra(list(sample(R1),sample(R1)))
})))
lines(1:length(R1),arand,col=2,lwd=3)

l <- c(1,2,3,4,5,7,6,8,9,10,11,12,13)
l <- 1:100
aa <- sapply(1:20,function(i){
    sra(list(sample(l),sample(l),sample(l)))[i]
})
c(mean(aa),sd(aa))

}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
