# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute the overlap between k ranked lists
#' 
#' @description Computes the overlap (number of items present in all k lists divided by the current rank) for each rank in the k lists
#' @param rankMat A matrix with k columns corresponding to the k ranked lists. Elements of each column are integers between 1 and the length of the lists
#' @return A vector of the same length as the rows in rankMat containing the overlap between the lists for each rank
#' @author Claus Ekstrøm <ekstrom@@sund.ku.dk>
#' @export
overlap <- function(rankMat) {
    .Call('_SuperRanker_overlap', PACKAGE = 'SuperRanker', rankMat)
}

#' Compute the sequential rank agreement between k ranked lists
#' 
#' @description Computes the sequential rank agreement (number of items present in all k lists divided by the current rank) for each rank in the k lists
#' @param rankMat A matrix with k columns corresponding to the k ranked lists. Elements of each column are integers between 1 and the length of the lists
#' @param maxlength The maximum depth that are needed XXX
#' @param B The number of resamples to use in the presence of censored lists
#' @param cens A vector of integer values that
#' @param type The type of distance measure to use: 0 (the default) is the variance while 1 is MAD (median absolute deviation)
#' @param epsilon A non-negative numeric vector that contains the minimum limit in proportion of lists that must show the item. Defaults to 0. If a single number is provided then the value will be recycles to the number of items.
#' @return A vector of the same length as the rows in rankMat containing the squared (!) sequential rank agreement between the lists for each depth. If the MAD type was chosen then the sequential MAD values are returned
#' @author Claus Ekstrøm <ekstrom@@sund.ku.dk>
#' @encoding UTF-8 
sracpp <- function(rankMat, maxlength, B, cens, type = 0L, epsilon = as.numeric( c(0))) {
    .Call('_SuperRanker_sracpp', PACKAGE = 'SuperRanker', rankMat, maxlength, B, cens, type, epsilon)
}

#' Compute the sequential rank agreement between k ranked lists
#' 
#' @description Computes the sequential rank agreement (number of items present in all k lists divided by the current rank) for each rank in the k lists
#' @param rankMat A matrix with k columns corresponding to the k ranked lists. Elements of each column are integers between 1 and the length of the lists
#' @param type The type of distance measure to use: 0 (the default) is the variance while 1 is MAD (mean absolute deviation)
#' @param epsilon A non-negative numeric vector that contains the minimum limit in proportion of lists that must show the item. Defaults to 0. If a single number is provided then the value will be recycles to the number of items.
#' @return A vector of the same length as the rows in rankMat containing the sequential rank agreement between the lists for each depth (squared for type=0)
#' @author Claus Ekstrøm <ekstrom@@sund.ku.dk>
#' @encoding UTF-8 
sracppfull <- function(rankMat, type = 0L, epsilon = as.numeric( c(0))) {
    .Call('_SuperRanker_sracppfull', PACKAGE = 'SuperRanker', rankMat, type, epsilon)
}

