% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.xgboost.R
\name{create.SL.xgboost}
\alias{create.SL.xgboost}
\title{Factory for XGBoost SL wrappers}
\usage{
create.SL.xgboost(tune = list(ntrees = c(1000), max_depth = c(4), shrinkage =
  c(0.1), minobspernode = c(10)), detailed_names = F, env = .GlobalEnv,
  name_prefix = "SL.xgb")
}
\arguments{
\item{tune}{List of hyperparameter settings to test. If specified, each hyperparameter will need to be defined.}

\item{detailed_names}{Set to T to have the function names include the parameter configurations.}

\item{env}{Environment in which to create the SL.xgboost functions. Defaults to the global environment.}

\item{name_prefix}{The prefix string for the name of each function that is generated.}
}
\description{
Create multiple configurations of XGBoost learners based on the desired combinations of hyperparameters.
}
\examples{

# Create a new environment to store the learner functions.
# This keeps the global environment organized.
sl_env = new.env()
# Create 2 * 2 * 1 * 3 = 12 combinations of hyperparameters.
tune = list(ntrees = c(100, 500), max_depth = c(1, 2), minobspernode = 10,
            shrinkage = c(0.1, 0.01, 0.001))
# Generate a separate learner for each combination.
xgb_grid = create.SL.xgboost(tune = tune, env = sl_env)
# Review the function configurations.
xgb_grid
# Attach the environment so that the custom learner functions can be accessed.
attach(sl_env)
\dontrun{
sl = SuperLearner(Y = Y, X = X, SL.library = xgb_grid$names)
}
detach(sl_env)
}

