% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pex-acf.R
\name{pex.acf}
\alias{pex.acf}
\title{Power-exponential autocorrelation function.}
\usage{
pex.acf(tseq, lambda, rho)
}
\arguments{
\item{tseq}{Length-\code{N} vector of timepoints.}

\item{lambda}{Timescale parameter.}

\item{rho}{Power parameter.}
}
\value{
Length-\code{N} autocorrelation vector.
}
\description{
Power-exponential autocorrelation function.
}
\details{
The power-exponential autocorrelation function is given by:
\deqn{
\mathrm{\scriptsize ACF}(t) = \exp \left\{-(t/\lambda)^\rho\right\}.
}{
acf(t) = exp (-(t / \lambda)^\rho).
}
}
\examples{
pex.acf(tseq = 1:10, lambda = 1, rho = 2)
}
