% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dSnorm.R
\name{dSnorm}
\alias{dSnorm}
\alias{dSnormDL}
\title{Density of a multivariate normal with Toeplitz variance matrix.}
\usage{
dSnorm(X, mu, acf, log = FALSE)

dSnormDL(X, mu, acf, log = FALSE)
}
\arguments{
\item{X}{Vector or matrix, of which each column is a multivariate observation.}

\item{mu}{Vector or matrix of mean values of compatible dimensions with \code{X}.  Defaults to all zeros.}

\item{acf}{Vector containing the first column of the Toeplitz variance matrix.  For \code{dSnorm}, can also be a \code{Toeplitz} object.}

\item{log}{Logical, whether to return the multivariate normal density on the log scale.}
}
\value{
Vector of (log-)densities, one for each column of \code{X}.
}
\description{
Efficient density evaluation for the multivariate normal distribution with Toeplitz variance matrix.
}
\details{
\code{dSnorm} and \code{dSnormDL} have identical outputs, with the former using the generalized Schur algorithm and the latter, the Durbin-Levinson algorithm, which is more common but slower.  \code{dSnormDL} is provided mainly for speed comparisons.
}
\examples{
N <- 10
d <- 4
X <- matrix(rnorm(N*d), N, d)
theta <- 0.1
lambda <- 2

mu <- theta^2 * rep(1, N)
acf <- exp(-lambda * (1:N - 1))
acf <- Toeplitz(acf = acf)

dSnorm(X, mu, acf, log = TRUE)
}
