% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30-nightingale_rose.R
\name{plot_nightingale_effect}
\alias{plot_nightingale_effect}
\title{Nightingale plot with treatment effects}
\usage{
plot_nightingale_effect(
  dat,
  covari.sel,
  trt.sel,
  resp.sel,
  outcome.type,
  seq_by = 100,
  range.strip = c(-6, 6),
  n.brk = 30,
  n.brk.axis = NULL,
  title = NULL,
  strip = NULL,
  effect = c("HR", "RMST"),
  time = NULL,
  show.overall = FALSE,
  lab.y = NULL,
  palette = "hcl",
  col.power = 0.5
)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{seq_by}{a number specifying the breaks in the y-axis}

\item{range.strip}{a vector with two elements specifying the range of treatment effect size for display}

\item{n.brk}{a number specifying the number of the points dividing the range of the argument "range.strip".}

\item{n.brk.axis}{a number specifying the number of breakpoints dividing the axis of the argument "range.strip".}

\item{title}{a string specifying the main title.}

\item{strip}{a string specifying the title of the colour strip.}

\item{effect}{either "HR" or "RMST". only when outcome.type = "survival"}

\item{time}{time for calculating the RMST}

\item{show.overall}{A logical indicating whether to show the overall treatment effect and its confidence intervals in the reference strip}

\item{lab.y}{a character value specifying the label of the y axis}

\item{palette}{either "divergent" or "hcl"}

\item{col.power}{to be used when palette = "hcl". see colorspace package for reference}
}
\description{
This function produces a nightingale plot with treatment effects across subgroups
}
\examples{
data(prca)
dat <- prca
vars <- data.frame(variable = names(dat), index = 1:length(names(dat)))
levels(dat$age_group) <- c("Young", "Middle-aged", "Old")
levels(dat$weight_group) <- c("Low", "Mid", "High")
names(dat)[c(14,15)] <- c("Age", "Weight")

strip.title = "Treatment effect size (log hazard ratio)"
plot_nightingale_effect(dat,
                        covari.sel = c(14,15),
                        trt.sel = 3,
                        resp.sel = c(1, 2),
                        outcome.type = "survival",
                        range.strip=c(-3, 3),
                        n.brk = 31,
                        n.brk.axis =  7,
                        title = "Total sample size = 475",
                        strip = strip.title, effect = "HR",
                        show.overall = TRUE, palette = "hcl")

}
