% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varStrat.R
\name{varEst}
\alias{varEst}
\title{Estimator of the approximated variance for balanced sampling}
\usage{
varEst(X, strata, pik, s, y)
}
\arguments{
\item{X}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{strata}{A vector of integers that represents the categories.}

\item{pik}{A vector of inclusion probabilities.}

\item{s}{A sample (vector of 0 and 1, if rejected or selected).}

\item{y}{A variable of interest.}
}
\value{
a scalar, the value of the estimated variance.
}
\description{
Estimator of the approximated variance for balanced sampling
}
\details{
This function gives an estimator of the approximated variance of the Horvitz-Thompson total estimator presented by Hasler C. and Tillé Y. (2014).
}
\examples{

N <- 1000
n <- 400
x1 <- rgamma(N,4,25)
x2 <- rgamma(N,4,25)

strata <- as.matrix(rep(1:40,each = 25)) # 25 strata
Xcat <- disjMatrix(strata)
pik <- rep(n/N,N)
X <- as.matrix(matrix(c(x1,x2),ncol = 2))
 
s <- stratifiedcube(X,strata,pik)
 
y <- 20*strata + rnorm(1000,120) # variable of interest
# y_ht <- sum(y[which(s==1)]/pik[which(s == 1)]) # Horvitz-Thompson estimator
# (sum(y_ht) - sum(y))^2 # true variance
varEst(X,strata,pik,s,y)
varApp(X,strata,pik,y)
}
\references{
Hasler, C. and Tillé, Y. (2014). Fast balanced sampling for highly stratified population. \emph{Computational Statistics and Data Analysis}, 74:81-94.
}
\seealso{
\code{\link{varApp}}
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
