% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_c50.R
\name{varimp_stratified_rf}
\alias{varimp_stratified_rf}
\title{Heuristic on variable importance}
\usage{
varimp_stratified_rf(model, metric = "usage")
}
\arguments{
\item{model}{A stratified_rf model.}

\item{metric}{How to calculate the variable importance from each tree. Either "usage" or "splits".}
}
\value{
A named data frame with the importance score of each variable, sorted from largest to smallest.
}
\description{
Heuristic on variable importance, taken as averages from the variable importances calculated for each tree.
}
\details{
Methods are taken directly from the C5.0 trees.
}
\examples{
data(iris)
groups <- list(c("Sepal.Length","Sepal.Width"),c("Petal.Length","Petal.Width"))
mtry <- c(1,1)
m <- stratified_rf(iris,"Species",groups,mtry,ntrees=2)
varimp_stratified_rf(m)
}
