% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_run.R
\name{e2e_run}
\alias{e2e_run}
\title{Run the StrathE2E model with a given configuration.}
\usage{
e2e_run(model, nyears = 20, quiet = TRUE, csv.output = FALSE)
}
\arguments{
\item{model}{R-list object defining the model configuration and compiled by the e2e_read() function.}

\item{nyears}{Number of years (integer) to run the model (default=20).}

\item{quiet}{Logical. If FALSE then see status outputs during the model run (default=TRUE).}

\item{csv.output}{Logical. If TRUE then enable writing of csv output files (default=FALSE).}
}
\value{
Model outputs as an R-list object and optionally csv files.
}
\description{
Perform a single deterministic run of the StrathE2E model for a configuration
defined by an R-list object compiled by a prior call of the e2e_read() function.
}
\details{
The function solves a network of Ordinary Differential Equations using the lsoda function
in the R deSolve package. The equations represent a shelf-sea food web and its connections to the physical and chemical environment,
and to a set of fishing fleets.

The outputs from the run are time series (daily intervals) of the masses of each of the state
variables, the fluxes between all state variable, and the fluxes in and out of the model including
fishery landings. In addition, a range of derived quantities are generated for the final year of the
run, including annual averages, maxima and minima of state variables, annual fluxes between state variables, annual landings and
discards of each guild of taxa by each fleet of fishing gears, and a set of
network indices generated by the R NetIndices package.
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
    model <- e2e_read("North_Sea", "2003-2013")

# Run the model for 2 years and generate the results object
    results <- e2e_run(model,nyears=2)
# Set csv.output=TRUE to save results to csv files to the directory
# specified in the e2e_read() function call.

# Time series plot of state varaiables over the full length of the run
    e2e_plot_ts(model, results,selection="ECO")
    dev.new()
    e2e_plot_ts(model, results,selection="CATCH")
}
\seealso{
\code{\link{e2e_ls}}, \code{\link{e2e_read}}, \code{\link{e2e_copy}}, \code{\link{e2e_plot_ts}}
}
