% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plants_nb.R
\name{get_plants_nb}
\alias{get_plants_nb}
\title{Getting plants number per usm for all usms or selected from a usm
name vector}
\usage{
get_plants_nb(
  usms_file,
  usms_list = c(),
  usm_file_path = lifecycle::deprecated()
)
}
\arguments{
\item{usms_file}{Path (including name) of a USM xml file or of a
new_travail.usm file}

\item{usms_list}{Usm(s) name(s) (optional, see details)}

\item{usm_file_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usm_file_path} is no
longer supported, use \code{usms_file} instead.}
}
\value{
A named numeric vector of plants number per usm
}
\description{
Extracting plant number from usms.xml or new_travail.usm
file data
}
\details{
Use \code{get_usms_list()} to get the list of the usm names for
an usms.xml file.
}
\examples{
# Xml case
xml_usms <- file.path(get_examples_path(file_type = "xml"), "usms.xml")
get_plants_nb(xml_usms)
get_plants_nb(xml_usms, "wheat")
get_plants_nb(xml_usms, c("wheat", "intercrop_pea_barley"))

# Txt case
txt_usm <- file.path(get_examples_path(file_type = "txt"), "new_travail.usm")
get_plants_nb(txt_usm)

}
