% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stics_examples_utils.R
\name{get_examples_path}
\alias{get_examples_path}
\title{Getting examples files path attached to a STICS version for a given file type}
\usage{
get_examples_path(
  file_type,
  stics_version = "latest",
  overwrite = FALSE,
  version_name = lifecycle::deprecated()
)
}
\arguments{
\item{file_type}{A file type string among files types or a vector of
("csv", "obs", "sti", "txt", "xml")}

\item{stics_version}{Name of the STICS version. Optional, by default
the latest version returned by \code{get_stics_versions_compat()} is used.}

\item{overwrite}{TRUE for overwriting directory; FALSE otherwise}

\item{version_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version_name} is no
longer supported, use \code{stics_version} instead.}
}
\value{
A directory path for examples files for given file type and STICS
version or a vector of (for unknown file types "" is returned as path)
}
\description{
Getting examples files path attached to a STICS version for a given file type
}
\examples{
get_examples_path(file_type = "csv")

get_examples_path(file_type = c("csv", "sti"))

get_examples_path(file_type = "csv", stics_version = "V8.5")

}
