% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{translateSqlFile}
\alias{translateSqlFile}
\title{Translate a SQL file}
\usage{
translateSqlFile(
  sourceFile,
  targetFile,
  targetDialect,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  oracleTempSchema = NULL
)
}
\arguments{
\item{sourceFile}{The source SQL file}

\item{targetFile}{The target SQL file}

\item{targetDialect}{The target dialect. Currently "oracle", "postgresql", "pdw", "impala",
"sqlite", "netezza", "bigquery", "snowflake", "synapse", "spark", and "redshift" are supported.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}
}
\description{
This function takes SQL and translates it to a different dialect.
}
\details{
This function takes SQL and translates it to a different dialect.
}
\examples{
\dontrun{
translateSqlFile("myRenderedStatement.sql",
  "myTranslatedStatement.sql",
  targetDialect = "postgresql"
)
}
}
