% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{loadRenderTranslateSql}
\alias{loadRenderTranslateSql}
\title{Load, render, and translate a SQL file in a package}
\usage{
loadRenderTranslateSql(
  sqlFilename,
  packageName,
  dbms = "sql server",
  ...,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  oracleTempSchema = NULL,
  warnOnMissingParameters = TRUE
)
}
\arguments{
\item{sqlFilename}{The source SQL file}

\item{packageName}{The name of the package that contains the SQL file}

\item{dbms}{The target dialect. Currently 'sql server', 'oracle', 'postgres',
and 'redshift' are supported}

\item{...}{Parameter values used for \code{render}}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{oracleTempSchema}{DEPRECATED: use \code{tempEmulationSchema} instead.}

\item{warnOnMissingParameters}{Should a warning be raised when parameters provided to this
function do not appear in the parameterized SQL that is being
rendered? By default, this is TRUE.}
}
\value{
Returns a string containing the rendered SQL.
}
\description{
\code{loadRenderTranslateSql} Loads a SQL file contained in a package, renders it and translates it
to the specified dialect
}
\details{
This function looks for a SQL file with the specified name in the inst/sql/<dbms> folder of the
specified package. If it doesn't find it in that folder, it will try and load the file from the
inst/sql/sql_server folder and use the \code{translate} function to translate it to the requested
dialect. It will subsequently call the \code{render} function with any of the additional specified
parameters.
}
\examples{
\dontrun{
renderedSql <- loadRenderTranslateSql("CohortMethod.sql",
  packageName = "CohortMethod",
  dbms = connectionDetails$dbms,
  CDM_schema = "cdmSchema"
)
}
}
