% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_chisq.test.R
\name{p_chisq.test}
\alias{p_chisq.test}
\alias{gen_chisq.test}
\title{p-value from chi-squared test simulation}
\usage{
p_chisq.test(
  n,
  w,
  df,
  correct = TRUE,
  P0 = NULL,
  P = NULL,
  gen_fun = gen_chisq.test,
  ...
)

gen_chisq.test(n, P, ...)
}
\arguments{
\item{n}{sample size per group}

\item{w}{Cohen's w effect size}

\item{df}{degrees of freedom}

\item{correct}{logical; apply continuity correction?}

\item{P0}{specific null pattern, specified as a numeric vector or matrix}

\item{P}{specific power configuration, specified as a numeric vector or matrix}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{matrix} with k rows and k columns
of counts. Default uses \code{\link{gen_chisq.test}}.
User defined version of this function must include the argument \code{...}}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates multinomial data suitable for analysis with
\code{\link{chisq.test}}.
}
\examples{

# effect size w + df
p_chisq.test(100, w=.2, df=3)

# vector of explicit probabilities (goodness of fit test)
p_chisq.test(100, P0 = c(.25, .25, .25, .25),
                   P = c(.6, .2, .1, .1))

# matrix of explicit probabilities (two-dimensional test of independence)
p_chisq.test(100, P0 = matrix(c(.25, .25, .25, .25), 2, 2),
                   P = matrix(c(.6, .2, .1, .1),2,2))

\donttest{
    # compare simulated results to pwr package

    P0 <- c(1/3, 1/3, 1/3)
    P <- c(.5, .25, .25)
    w <- pwr::ES.w1(P0, P)
    df <- 3-1
    pwr::pwr.chisq.test(w=w, df=df, N=100, sig.level=0.05)

    # slightly less power when evaluated empirically
    p_chisq.test(n=100, w=w, df=df) |> Spower(replications=100000)
    p_chisq.test(n=100, P0=P0, P=P) |> Spower(replications=100000)

    # slightly differ (latter more conservative due to finite sampling behaviour)
    pwr::pwr.chisq.test(w=w, df=df, power=.8, sig.level=0.05)
    p_chisq.test(n=NA, w=w, df=df) |>
           Spower(power=.80, interval=c(50, 200))
    p_chisq.test(n=NA, w=w, df=df, correct=FALSE) |>
           Spower(power=.80, interval=c(50, 200))

    # Spower slightly more conservative even with larger N
    pwr::pwr.chisq.test(w=.1, df=df, power=.95, sig.level=0.05)
    p_chisq.test(n=NA, w=.1, df=df) |>
           Spower(power=.95, interval=c(1000, 2000))
    p_chisq.test(n=NA, w=.1, df=df, correct=FALSE) |>
           Spower(power=.95, interval=c(1000, 2000))

}

}
\seealso{
\code{\link{gen_chisq.test}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
