% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{swd}
\alias{swd}
\title{Sum Within Distance (Spatially Balanced Sampling).}
\usage{
swd(dis, niter, nsamp, nrepl, bexp)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs of units in the population.}

\item{niter}{Number of iterations for the algorithm.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples drawn.}

\item{bexp}{Parameter \eqn{\beta} for the algorithm. The higher \eqn{\beta} is, the more the sample is going to be spread.}
}
\value{
Return a matrix 2 x \code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
}
\description{
This is an implemention of a spatially balanced design, with a probability function proportional to the within sample distance, using the sum of distance as an index of the within sample distance (Sum Within Distance, \code{swd} in short).
To have a constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, standardize the distance matrix with function \code{\link{stsum}}.
}
\examples{
#Example 1
#Draw 20 samples of dimension 15 without constant probabilities
dis<-as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) #distance matrix
nsamp<-15  #sample size
nrepl<-20  #number of samples to draw
niter<-10  #number of iterations in the algorithm
bexp<-10   #parameter \\eqn{\\beta}
drawn_samples<-swd(dis,niter,nsamp,nrepl,bexp)  #drawn samples
\donttest{
#Example 2
#Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
#with N=population size
dis<-as.matrix(dist(cbind(income_emilia$x_coord,income_emilia$y_coord))) #distance matrix
nsamp<-15  #sample size
nrepl<-20  #numbers of samples to drawn
niter<-10  #numbers of iterations in the algorithm
bexp<-10  #parameter \\eqn{\\beta}
vec<-rep(1,nrow(dis)) #vector of constraints
stand_dist<-stsum(dis,vec,1e-15,1000) #standardized matrix
drawn_samples<-swd(stand_dist,niter,nsamp,nrepl,bexp)  #drawn samples
}
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}
}
