% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NYleukemia_sf.R
\docType{data}
\name{NYleukemia_sf}
\alias{NYleukemia_sf}
\title{Upstate New York Leukemia}
\format{
An sf 'POLYGON' data frame with 281 rows  and 4 variables:
\describe{
\item{geometry}{Geometric representation of 8 counties in upstate New York }
\item{cases}{Number of cases per county}
\item{population}{Population of each census tract}
\item{censustract.FIPS}{11-digit Federal Information Processing System identification number for each county}

}
}
\source{
Turnbull, B. W. et al (1990) Monitoring for clusters of disease: application to leukemia incidence in upstate New York \emph{American Journal of Epidemiology}, \bold{132}, 136--143
}
\usage{
NYleukemia_sf
}
\description{
Census tract level (\code{n=281}) leukemia data for the 8 counties in upstate New York from 1978-1982, paired with population data from the 1980 census.
Note that 4 census tracts were completely surrounded by another unique census tract;
when applying the Bayesian cluster detection model in \code{\link{bayes_cluster}},
we merge them with the surrounding census tracts yielding \code{n=277} areas.
}
\examples{

# Static map of NY Leukemia rate per county
library(ggplot2)
ggplot(NYleukemia_sf) + 
  geom_sf(aes(fill= cases/population)) + 
  scale_fill_gradient(low = "white", high = "red")
}
\keyword{datasets}
