% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{barErrorPlot}
\alias{barErrorPlot}
\title{Generate bar error plots}
\usage{
barErrorPlot(
  object,
  error = "MSE",
  by = "CellType",
  dispersion = "se",
  filter.sc = TRUE,
  title = NULL,
  angle = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{trained.model} slot containing metrics in the
\code{test.deconv.metrics} slot of a \code{\linkS4class{DeconvDLModel}}
object.}

\item{error}{\code{'MAE'} or \code{'MSE'}.}

\item{by}{Variable used to show errors. Available options are:
\code{'nCellTypes'}, \code{'CellType'}.}

\item{dispersion}{Standard error (\code{'se'}) or standard deviation
(\code{'sd'}). The former by default.}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only correlation of results associated with mixed transcriptional
profiles are shown (\code{TRUE} by default).}

\item{title}{Title of the plot.}

\item{angle}{Angle of ticks.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object.
}
\description{
Generate bar error plots by cell type (\code{CellType}) or by number of
different cell types (\code{nCellTypes}) on test mixed transcriptional
profiles.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 100,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
SDDLS <- simMixedProfiles(SDDLS)
# training of DDLS model
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 10,
  num.epochs = 5
)
# evaluation using test data
SDDLS <- calculateEvalMetrics(object = SDDLS)
# bar error plots
barErrorPlot(
  object = SDDLS,
  error = "MSE",
  by = "CellType"
)
barErrorPlot(
  object = SDDLS,
  error = "MAE",
  by = "nCellTypes"
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{corrExpPredPlot}}
\code{\link{distErrorPlot}} \code{\link{blandAltmanLehPlot}}
}
