% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{cv.covfn}
\alias{cv.covfn}
\title{M-fold cross-validation for covariance matrix estimation}
\usage{
cv.covfn(basis, M = 5, gamma = NULL)
}
\arguments{

\item{basis}{"cv.spatpca" object or "spatpca" object.}

\item{M}{Optional number of folds; default is 5. Smallest value allowable is M=2.}

\item{gamma}{Optional user-supplied numeric vector of a nonnegative tuning parameter sequence. If NULL, 10 values in a range are used.}
}
\value{
\item{cov}{Estimated covariance matrix at the locations with respect to the selected tuning parameter.}

\item{gamma.cv}{Selected gamma.}

\item{cv}{cv socres corresponding to gamma.}

\item{gamma}{Sequence of gamma-values used in the process.}
}
\description{
Execute M-fold cross-validation to select the tuning parameter, gamma, and produce the corresponding estimated covariance matrix.
}
\examples{
\dontrun{
## 1D case
s.1D <- as.matrix(seq(-5, 5, length = 50))
Phi.true.1D <- exp(-s.1D^2)/norm(exp(-s.1D^2), "F")
Y.1D <- rnorm(n = 100, sd = 3)\%*\%t(Phi.true.1D) + matrix(rnorm(n = 100*50), 100, 50)
cv.1D <- cv.spatpca(Y = Y.1D, sx = s.1D, K = 3)
cov.est <- cv.covfn(basis = cv.1D)}
}
\author{
Wen-Ting Wang and Hsin-Cheng Huang
}
\references{
Tzeng, S. and Huang, H.-C. (2015). Non-stationary multivariate spatial covariance estimation via low-rank regularization. \emph{Statistical Sinica} \bold{26} 151-172.

Wang, W.-T. and Huang, H.-C. (2015). Regularized principal component analysis for spatial data. arXiv:1501.03221.
}
\seealso{
\code{\link{spatpca}}, \code{\link{cv.spatpca}}
}

