% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{varshannonZ}
\alias{varshannonZ}
\title{Estimated variance of Shannon's entropy of \eqn{Z}.}
\usage{
varshannonZ(data)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
Alternatively, a marked \code{ppp} object.}
}
\value{
the estimated variance of Shannon's entropy of \eqn{Z}.
}
\description{
This function estimates the variance of Shannon's entropy of \eqn{Z}, where \eqn{Z} identifies pairs of categories of the original study variable.
}
\details{
\link{varshannonZ} estimates the
variance of the maximum likelihood estimator of Shannon's entropy of \eqn{Z} given by
\link{shannonZ}. The variance is \deqn{V(H(Z))=H(Z)_2- H(Z)^2}, where
\deqn{H(Z)_2=\sum p(z_r)\log(1/p(z_r))^2}.
The function is able to work with lattice data with missing data, as long as they are specified as NAs:
missing data are ignored in the computations.
}
\examples{
#NON SPATIAL DATA
data=sample(1:5, 50, replace=TRUE)
varshannonZ(data)

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
varshannonZ(marks(data.pp))

#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
varshannonZ(data.lat)

}
