% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bolognaW}
\alias{bolognaW}
\title{Observation window for Bologna urban data.}
\format{
An \code{owin} object. The basic spatial unit is a 250x250 metres pixels.
}
\source{
EEA (2011). Corine land cover 2000 raster data. Technical Report, downloadable at
http://www.eea.europa.eu/data-and-maps/ data/corine-land-cover-2000-raster-1
}
\usage{
bolognaW
}
\description{
An \code{owin} object with the rectangle circumscribing the city border for the Bologna dataset.
}
\details{
This observation window is an \code{owin} object with margins given by the CORINE project coordinates.
See \code{?owin} for details.
Examples on the usefulness of the window can be found at the topic \link{bologna}.
}
\examples{
data(bolognaW)
plot(bolognaW, main="")
plot(as.im(bologna, W=bolognaW), main="", col=gray(c(0.8,0)), ribbon=FALSE, add=TRUE)

#see examples under the topic "bologna"
}
\keyword{datasets}
