% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{sparkR.conf}
\alias{sparkR.conf}
\title{Get Runtime Config from the current active SparkSession}
\usage{
sparkR.conf(key, defaultValue)
}
\arguments{
\item{key}{(optional) The key of the config to get, if omitted, all config is returned}

\item{defaultValue}{(optional) The default value of the config to return if they config is not
set, if omitted, the call fails if the config key is not set}
}
\value{
a list of config values with keys as their names
}
\description{
Get Runtime Config from the current active SparkSession.
To change SparkSession Runtime Config, please see \code{sparkR.session()}.
}
\note{
sparkR.conf since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
allConfigs <- sparkR.conf()
masterValue <- unlist(sparkR.conf("spark.master"))
namedConfig <- sparkR.conf("spark.executor.memory", "0g")
}
}
