% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_stat.R
\docType{methods}
\name{spark.kstest}
\alias{spark.kstest}
\alias{spark.kstest,SparkDataFrame-method}
\alias{summary,KSTest-method}
\alias{print.summary.KSTest}
\title{(One-Sample) Kolmogorov-Smirnov Test}
\usage{
spark.kstest(data, ...)

\S4method{spark.kstest}{SparkDataFrame}(data, testCol = "test",
  nullHypothesis = c("norm"), distParams = c(0, 1))

\S4method{summary}{KSTest}(object)

\method{print}{summary.KSTest}(x, ...)
}
\arguments{
\item{data}{a SparkDataFrame of user data.}

\item{...}{additional argument(s) passed to the method.}

\item{testCol}{column name where the test data is from. It should be a column of double type.}

\item{nullHypothesis}{name of the theoretical distribution tested against. Currently only
\code{"norm"} for normal distribution is supported.}

\item{distParams}{parameters(s) of the distribution. For \code{nullHypothesis = "norm"},
we can provide as a vector the mean and standard deviation of
the distribution. If none is provided, then standard normal will be used.
If only one is provided, then the standard deviation will be set to be one.}

\item{object}{test result object of KSTest by \code{spark.kstest}.}

\item{x}{summary object of KSTest returned by \code{summary}.}
}
\value{
\code{spark.kstest} returns a test result object.

\code{summary} returns summary information of KSTest object, which is a list.
        The list includes the \code{p.value} (p-value), \code{statistic} (test statistic
        computed for the test), \code{nullHypothesis} (the null hypothesis with its
        parameters tested against) and \code{degreesOfFreedom} (degrees of freedom of the test).
}
\description{
\code{spark.kstest} Conduct the two-sided Kolmogorov-Smirnov (KS) test for data sampled from a
continuous distribution.

By comparing the largest difference between the empirical cumulative
distribution of the sample data and the theoretical distribution we can provide a test for the
the null hypothesis that the sample data comes from that theoretical distribution.

Users can call \code{summary} to obtain a summary of the test, and \code{print.summary.KSTest}
to print out a summary result.
}
\note{
spark.kstest since 2.1.0

summary(KSTest) since 2.1.0

print.summary.KSTest since 2.1.0
}
\examples{
\dontrun{
data <- data.frame(test = c(0.1, 0.15, 0.2, 0.3, 0.25))
df <- createDataFrame(data)
test <- spark.kstest(df, "test", "norm", c(0, 1))

# get a summary of the test result
testSummary <- summary(test)
testSummary

# print out the summary in an organized way
print.summary.KSTest(testSummary)
}
}
\seealso{
\href{http://spark.apache.org/docs/latest/mllib-statistics.html#hypothesis-testing}{
         MLlib: Hypothesis Testing}
}
