% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/WindowSpec.R
\docType{methods}
\name{orderBy}
\alias{orderBy}
\alias{orderBy}
\alias{orderBy,WindowSpec,character-method}
\alias{orderBy}
\alias{orderBy,WindowSpec,Column-method}
\title{Ordering Columns in a WindowSpec}
\usage{
orderBy(x, col, ...)

\S4method{orderBy}{WindowSpec,character}(x, col, ...)

\S4method{orderBy}{WindowSpec,Column}(x, col, ...)
}
\arguments{
\item{x}{a WindowSpec}

\item{col}{a character or Column indicating an ordering column}

\item{...}{additional sorting fields}
}
\value{
A WindowSpec.
}
\description{
Defines the ordering columns in a WindowSpec.
}
\note{
orderBy(WindowSpec, character) since 2.0.0

orderBy(WindowSpec, Column) since 2.0.0
}
\examples{
\dontrun{
  orderBy(ws, "col1", "col2")
  orderBy(ws, df$col1, df$col2)
}
}
\seealso{
See \link{arrange} for use in sorting a SparkDataFrame

Other windowspec_method: \code{\link{partitionBy}},
  \code{\link{rangeBetween}}, \code{\link{rowsBetween}}
}
