% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{column_datetime_diff_functions}
\alias{column_datetime_diff_functions}
\alias{datediff,Column-method}
\alias{datediff}
\alias{months_between,Column-method}
\alias{months_between}
\alias{date_format,Column,character-method}
\alias{date_format}
\alias{from_utc_timestamp,Column,character-method}
\alias{from_utc_timestamp}
\alias{next_day,Column,character-method}
\alias{next_day}
\alias{to_utc_timestamp,Column,character-method}
\alias{to_utc_timestamp}
\alias{add_months,Column,numeric-method}
\alias{add_months}
\alias{date_add,Column,numeric-method}
\alias{date_add}
\alias{date_sub,Column,numeric-method}
\alias{date_sub}
\title{Date time arithmetic functions for Column operations}
\usage{
add_months(y, x)

datediff(y, x)

date_add(y, x)

date_format(y, x)

date_sub(y, x)

from_utc_timestamp(y, x)

months_between(y, x)

next_day(y, x)

to_utc_timestamp(y, x)

\S4method{datediff}{Column}(y, x)

\S4method{months_between}{Column}(y, x)

\S4method{date_format}{Column,character}(y, x)

\S4method{from_utc_timestamp}{Column,character}(y, x)

\S4method{next_day}{Column,character}(y, x)

\S4method{to_utc_timestamp}{Column,character}(y, x)

\S4method{add_months}{Column,numeric}(y, x)

\S4method{date_add}{Column,numeric}(y, x)

\S4method{date_sub}{Column,numeric}(y, x)
}
\arguments{
\item{y}{Column to compute on.}

\item{x}{For class \code{Column}, it is the column used to perform arithmetic operations
with column \code{y}. For class \code{numeric}, it is the number of months or
days to be added to or subtracted from \code{y}. For class \code{character}, it is
\itemize{
\item \code{date_format}: date format specification.
\item \code{from_utc_timestamp}, \code{to_utc_timestamp}: time zone to use.
\item \code{next_day}: day of the week string.
}}
}
\description{
Date time arithmetic functions defined for \code{Column}.
}
\details{
\code{datediff}: Returns the number of days from \code{y} to \code{x}.

\code{months_between}: Returns number of months between dates \code{y} and \code{x}.

\code{date_format}: Converts a date/timestamp/string to a value of string in the format
specified by the date format given by the second argument. A pattern could be for instance
\code{dd.MM.yyyy} and could return a string like '18.03.1993'. All
pattern letters of \code{java.text.SimpleDateFormat} can be used.
Note: Use when ever possible specialized functions like \code{year}. These benefit from a
specialized implementation.

\code{from_utc_timestamp}: Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a
time in UTC, and renders that time as a timestamp in the given time zone. For example, 'GMT+1'
would yield '2017-07-14 03:40:00.0'.

\code{next_day}: Given a date column, returns the first date which is later than the value of
the date column that is on the specified day of the week. For example,
\code{next_day("2015-07-27", "Sunday")} returns 2015-08-02 because that is the first Sunday
after 2015-07-27. Day of the week parameter is case insensitive, and accepts first three or
two characters: "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun".

\code{to_utc_timestamp}: Given a timestamp like '2017-07-14 02:40:00.0', interprets it as a
time in the given time zone, and renders that time as a timestamp in UTC. For example, 'GMT+1'
would yield '2017-07-14 01:40:00.0'.

\code{add_months}: Returns the date that is numMonths (\code{x}) after startDate (\code{y}).

\code{date_add}: Returns the date that is \code{x} days after.

\code{date_sub}: Returns the date that is \code{x} days before.
}
\note{
datediff since 1.5.0

months_between since 1.5.0

date_format since 1.5.0

from_utc_timestamp since 1.5.0

next_day since 1.5.0

to_utc_timestamp since 1.5.0

add_months since 1.5.0

date_add since 1.5.0

date_sub since 1.5.0
}
\examples{
\dontrun{
dts <- c("2005-01-02 18:47:22",
        "2005-12-24 16:30:58",
        "2005-10-28 07:30:05",
        "2005-12-28 07:01:05",
        "2006-01-24 00:01:10")
y <- c(2.0, 2.2, 3.4, 2.5, 1.8)
df <- createDataFrame(data.frame(time = as.POSIXct(dts), y = y))}

\dontrun{
tmp <- createDataFrame(data.frame(time_string1 = as.POSIXct(dts),
             time_string2 = as.POSIXct(dts[order(runif(length(dts)))])))
tmp2 <- mutate(tmp, datediff = datediff(tmp$time_string1, tmp$time_string2),
               monthdiff = months_between(tmp$time_string1, tmp$time_string2))
head(tmp2)}

\dontrun{
tmp <- mutate(df, from_utc = from_utc_timestamp(df$time, "PST"),
                 to_utc = to_utc_timestamp(df$time, "PST"))
head(tmp)}

\dontrun{
tmp <- mutate(df, t1 = add_months(df$time, 1),
                  t2 = date_add(df$time, 2),
                  t3 = date_sub(df$time, 3),
                  t4 = next_day(df$time, "Sun"))
head(tmp)}
}
\seealso{
Other data time functions: \code{\link{column_datetime_functions}}
}
