% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\docType{methods}
\name{Copy,simList-method}
\alias{Copy,simList-method}
\title{Copy for simList class objects}
\usage{
\S4method{Copy}{simList}(object, objects, queues)
}
\arguments{
\item{object}{An R object (likely containing environments) or an environment.}

\item{objects}{Whether the objects contained within the simList environment
should be copied. Default \code{TRUE}, which may be slow.}

\item{queues}{Logical. Should the events queues (\code{events},
\code{current}, \code{completed}) be deep copied via
\code{data.table::copy}}
}
\description{
Because a simList works with an environment to hold all objects,
all objects within that slot are pass-by-reference. That means
it is not possible to simply copy an object with an assignment operator:
the two objects will share the same objects. As one simList object changes
so will the other. when this is not the desired behaviour, use this function.
NOTE: use capital C, to limit confusion with \code{data.table::copy()}
See \code{\link[reproducible]{Copy}}.
}
\seealso{
\code{\link[reproducible]{Copy}}
}
\author{
Eliot McIntire
}
