% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{PBMC_metaData}
\alias{PBMC_metaData}
\title{PBMC 4K meta data}
\format{
\code{PBMC_metaData} is a data.frame with 4 columns: RD1, RD2, Cluster, and Annotation.
}
\source{
\url{https://support.10xgenomics.com/single-cell-gene-expression/datasets/2.1.0/pbmc4k}
}
\usage{
data(PBMC_metaData)
}
\description{
Collection of bits of meta data relating to the 10X PBMC 4K data.
}
\details{
This data set pertains to the 10X demonstration PBMC 4K data and includes metadata about it in the \code{data.frame} named \code{PBMC_metaData}.

\code{PBMC_metaData} was created using Seurat (v2) to calculate a tSNE representation of the data and cluster cells with these commands.
\itemize{
  \item \code{set.seed(1)}
  \item \code{srat = CreateSeuratObject(sc$toc)}
  \item \code{srat = NormalizeData(srat)}
  \item \code{srat = ScaleData(srat)}
  \item \code{srat = FindVariableGenes(srat)}
  \item \code{srat = RunPCA(srat,pcs.compute=30)}
  \item \code{srat = RunTSNE(srat,dims.use=seq(30))}
  \item \code{srat = FindClusters(srat,dims.use=seq(30),resolution=1)}
  \item \code{PBMC_metaData = as.data.frame(srat@dr$tsne@cell.embeddings)}
  \item \code{colnames(PBMC_metaData) = c('RD1','RD2')}
  \item \code{PBMC_metaData$Cluster = factor(srat@meta.data[rownames(PBMC_metaData),'res.1'])}
  \item \code{PBMC_metaData$Annotation = factor(c('7'='B','4'='B','1'='T_CD4','2'='T_CD4','3'='T_CD8','5'='T_CD8','6'='NK','8'='NK','0'='MNP','9'='MNP','10'='MNP','11'='?')[as.character(PBMC_metaData$Cluster)])}
}
}
\keyword{datasets}
