% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotChangeMap}
\alias{plotChangeMap}
\title{Plot maps comparing corrected/raw expression}
\usage{
plotChangeMap(
  sc,
  cleanedMatrix,
  geneSet,
  DR,
  dataType = c("soupFrac", "binary", "counts"),
  logData = FALSE,
  pointSize = 0.5
)
}
\arguments{
\item{sc}{SoupChannel object.}

\item{cleanedMatrix}{A cleaned matrix to compare against the raw one.  Usually the output of \code{\link{adjustCounts}}.}

\item{geneSet}{A vector with the names of the genes to aggregate and plot evidence for.}

\item{DR}{A data.frame, with rows named by unique cell IDs (i.e., <ChannelName>_<Barcode>) the first two columns of which give the coordinates of each cell in some reduced dimension representation of the data.}

\item{dataType}{How should data be represented.  Binary sets each cell to expressed or not, counts converts everything to counts, soupFrac plots the fraction of the observed counts that are identified as contamination (i.e., (old-new)/old) for each cell and is the default.}

\item{logData}{Should we log the thing we plot?}

\item{pointSize}{Size of points}
}
\value{
A ggplot2 containing the plot.
}
\description{
Given some reduced dimensional representation of the data (such as UMAP or tSNE) that has been calculated however you would like, this provides a way to visualise how the expression of a geneSet changes after soup correction.
}
\examples{
out = adjustCounts(scToy)
gg = plotChangeMap(scToy,out,'S100A9')
}
