% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaxonCriteria.R
\name{getTaxonCriteria}
\alias{getTaxonCriteria}
\title{Get Taxon Criteria from the Keys to Soil Taxonomy}
\usage{
getTaxonCriteria(
  taxon = NULL,
  code = NULL,
  level = c("order", "suborder", "greatgroup", "subgroup")
)
}
\arguments{
\item{taxon}{\emph{character}. Vector of taxon names (order to subgroup level). These values are converted to taxon "codes"}

\item{code}{\emph{character}. Vector of taxon codes.}

\item{level}{\emph{character}. One or more of: "order", "suborder", "greatgroup", "subgroup"}
}
\value{
A named list. Each list element is named based on the input value (either \code{taxon} or \code{code}) and contains a data.frame derived from dataset ST_criteria_13th.
}
\description{
Get Taxon Criteria from the Keys to Soil Taxonomy
}
\examples{
getTaxonCriteria(c("mollic haplocryalfs", "abruptic durixeralfs"))

getTaxonCriteria(code = "ABC", level = c("greatgroup"))
}
\seealso{
\code{\link[=taxon_to_taxon_code]{taxon_to_taxon_code()}}, \link{ST_criteria_13th}
}
