% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.idm.R
\name{predict.idm}
\alias{predict.idm}
\title{Predictions for an illness-death model using either a penalized likelihood
approach or a Weibull parametrization.}
\usage{
\method{predict}{idm}(
  object,
  s,
  t,
  newdata,
  nsim = 200,
  seed = 21,
  conf.int = 0.95,
  lifeExpect = FALSE,
  maxtime,
  ...
)
}
\arguments{
\item{object}{an \code{idm} class objects returned by a call to the
\code{\link{idm}} function}

\item{s}{time point at which prediction is made.}

\item{t}{time horizon for prediction.}

\item{newdata}{A data frame with covariate values for prediction.}

\item{nsim}{number of simulations for the confidence intervals
calculations.  The default is 200.}

\item{seed}{Seed passed to \code{set.seed} for Monte Carlo
simulation of confidence intervals.}

\item{conf.int}{Level of confidence, i.e., a value between 0 and 1,
the default is \code{0.95}.  The default is also used when
\code{conf.int=TRUE}.  To avoid computation of confidence
intervals, set \code{conf.int} to FALSE or NULL.}

\item{lifeExpect}{Logical. If \code{TRUE} compute life
expectancies, i.e., \code{t=Inf}.}

\item{maxtime}{The upper limit of integration for calculations of life expectancies from Weibull parametrizations.}

\item{...}{other parameters.}
}
\value{
a list containing the following predictions with pointwise
    confidence intervals: \item{p00}{the transition probability
    \eqn{p_{00}}.}  \item{p01}{the transition probability
    \eqn{p_{01}}.} \item{p11}{the transition probability
    \eqn{p_{11}}.} \item{p12}{the transition probability
    \eqn{p_{12}}.} \item{p02_0}{the probability of direct
    transition from state 0 to state 2.} \item{p02_1}{the
    probability of transition from state 0 to state 2 via state 1.}
    \item{p02}{transition probability \eqn{p_{02}}. Note that
    \code{p02}=\code{p_02_0}+\code{p02_1}.} \item{F01}{the lifetime
    risk of disease. \code{F01}=\code{p01}+\code{p02_1}.}
    \item{F0.}{the probability of exit from state
    0. \code{F0.}=\code{p02_0}+\code{p01}+\code{p02_1}.}
}
\description{
Predict transition probabilities and cumulative probabilities from an object
of class \code{idmSplines} with confidence intervals are calculated.
}
\examples{

\dontrun{
set.seed(100)
d=simulateIDM(n = 100)
fit <- idm(formula01=Hist(time=list(L,R),event=seen.ill)~X1+X2+X3,
               formula02=Hist(time=observed.lifetime,event=seen.exit)~X1+X2+X3,
               data=d,conf.int=FALSE)
predict(fit,s=0,t=80,conf.int=FALSE,lifeExpect=FALSE)
predict(fit,s=0,t=80,nsim=4,conf.int=TRUE,lifeExpect=FALSE)
predict(fit,s=0,t=80,nsim=4,conf.int=FALSE,lifeExpect=TRUE)

data(Paq1000)
library(prodlim)
fit.paq <- idm(formula02=Hist(time=t,event=death,entry=e)~certif,
formula01=Hist(time=list(l,r),event=dementia)~certif,data=Paq1000)

predict(fit.paq,s=70,t=80,newdata=data.frame(certif=1))
predict(fit.paq,s=70,lifeExpect=TRUE,newdata=data.frame(certif=1))

fit.splines <-  idm(formula02=Hist(time=t,event=death,entry=e)~certif,
		formula01=Hist(time=list(l,r),event=dementia)~certif,
                formula12=~1,
                method="Splines",
		data=Paq1000)

predict(fit.splines,s=70,t=80,newdata=data.frame(certif=1))
predict(fit.splines,s=70,t=80,lifeExpect=TRUE,newdata=data.frame(certif=1),nsim=20)


}

}
\seealso{
\code{\link{idm}}
}
\author{
R: Celia Touraine <Celia.Touraine@isped.u-bordeaux2.fr>
    and Thomas Alexander Gerds <tag@biostat.ku.dk> Fortran: Pierre
    Joly <Pierre.Joly@isped.u-bordeaux2.fr>
}
\keyword{methods}
