% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIS.R
\docType{class}
\name{SIS-class}
\alias{SIS-class}
\title{Definition of the \acronym{SIS} model}
\description{
Class to handle the \acronym{SIS} \code{\link{SimInf_model}}.
}
\details{
The \acronym{SIS} model contains two compartments; number of
susceptible (S), and number of infectious (I).  Moreover, it has
two state transitions, \deqn{S \stackrel{\beta S I /
N}{\longrightarrow} I}{ S -- beta S I / N --> I} \deqn{I
\stackrel{\gamma I}{\longrightarrow} S}{I -- gamma I --> S} where
\eqn{\beta} is the transmission rate, \eqn{\gamma} is the recovery
rate, and \eqn{N=S+I}.
}
\examples{
## Create an SIS model object.
model <- SIS(u0 = data.frame(S = 99, I = 1),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the SIS model and plot the result.
set.seed(22)
result <- run(model)
plot(result)
}
