% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SEIR.R, R/SIR.R, R/SISe.R,
%   R/SISe3.R, R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{susceptible}
\alias{susceptible}
\alias{susceptible,SEIR-method}
\alias{susceptible,SIR-method}
\alias{susceptible,SISe-method}
\alias{susceptible,SISe3-method}
\alias{susceptible,SISe3_sp-method}
\alias{susceptible,SISe_sp-method}
\title{Susceptible}
\usage{
susceptible(model, ...)

\S4method{susceptible}{SEIR}(model, i = NULL, ...)

\S4method{susceptible}{SIR}(model, i = NULL, ...)

\S4method{susceptible}{SISe}(model, i = NULL, ...)

\S4method{susceptible}{SISe3}(model, age = 1:3, i = NULL, ...)

\S4method{susceptible}{SISe3_sp}(model, age = 1:3, i = NULL, ...)

\S4method{susceptible}{SISe_sp}(model, i = NULL, ...)
}
\arguments{
\item{model}{The \code{model} to extract the susceptible from}

\item{...}{Additional arguments affecting the measure}

\item{i}{Indices specifying the nodes to include when extracting
the number of susceptible. Default is NULL, which includes all
nodes.}

\item{age}{For models with age categories, the age category to
extract.}
}
\description{
Extracts the number of susceptible.
}
\examples{
## Create an 'SIR' model with 5 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = rep(99, 5), I = rep(1, 5), R = rep(0, 5))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Run the model and save the result
result <- run(model)

## Extract the number of susceptible individuals in each
## node after each time step in the simulation
susceptible(result)

## Extract the number of susceptible individuals in the
## first node after each time step in the simulation
susceptible(result, i = 1)

## Extract the number of susceptible individuals in the
## first and third node after each time step in the simulation
susceptible(result, i = c(1, 3))
}
\keyword{methods}
