% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\name{SimInf_model}
\alias{SimInf_model}
\title{Create a \code{SimInf_model}}
\usage{
SimInf_model(G, S, tspan, events = NULL, ldata = NULL, gdata = NULL,
  U = NULL, u0 = NULL, v0 = NULL, V = NULL, E = NULL, N = NULL,
  C_code = NULL)
}
\arguments{
\item{G}{Dependency graph that indicates the transition rates that
need to be updated after a given state transition has occured.
A non-zero entry in element \code{G[i, i]} indicates that
transition rate \code{i} needs to be recalculated if the state
transition \code{j} occurs. Sparse matrix (\eqn{Nt \times Nt})
of object class \code{"\linkS4class{dgCMatrix}"}.}

\item{S}{Each column corresponds to a transition, and execution of
state transition \code{j} amounts to adding the \code{S[, j]}
to the state vector of the node where the state transition
occurred.  Sparse matrix (\eqn{Nc \times Nt}) of object class
\code{"\linkS4class{dgCMatrix}"}.}

\item{tspan}{A vector (length >= 2) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{A \code{data.frame} with the scheduled events.}

\item{ldata}{A matrix with local data for the nodes. The column
\code{ldata[, j]} contains the local data vector for the node
\code{j}. The local data vector is passed as an argument to
the transition rate functions and the post time step function.}

\item{gdata}{A numeric vector with global data that is common to
all nodes. The global data vector is passed as an argument to
the transition rate functions and the post time step function.}

\item{U}{The result matrix with the number of individuals in each
disease state in every node (\eqn{N_n N_c \times}
\code{length(tspan)}).  \code{U[, j]} contains the number of
individuals in each disease state at
\code{tspan[j]}. \code{U[1:Nc, j]} contains the state of node
\code{1} at \code{tspan[j]}. \code{U[(Nc + 1):(2 * Nc), j]}
contains the state of node \code{2} at \code{tspan[j]} etc.}

\item{u0}{The initial state vector. Either a matrix (\eqn{N_c
\times N_n}) or a a \code{data.frame} with the number of
individuals in each compartment in every node.}

\item{v0}{The initial continuous state vector in every node.
(\code{dim(ldata)[1]} \eqn{N_N \times}). The continuous state
vector is updated by the specific model during the simulation
in the post time step function.}

\item{V}{The result matrix for the real-valued continous
compartment state (\eqn{N_n}\code{dim(ldata)[1]} \eqn{\times}
\code{length(tspan)}).  \code{V[, j]} contains the real-valued
state of the system at \code{tspan[j]}.}

\item{E}{Sparse matrix to handle scheduled events, see
\code{\linkS4class{scheduled_events}}.}

\item{N}{Sparse matrix to handle scheduled events, see
\code{\linkS4class{scheduled_events}}.}

\item{C_code}{Character vector with optional model C code. If
non-empty, the C code is written to a temporary C-file when
the \code{run} method is called.  The temporary C-file is
compiled and the resulting DLL is dynamically loaded. The DLL
is unloaded and the temporary files are removed after running
the model.}
}
\value{
\linkS4class{SimInf_model}
}
\description{
Create a \code{SimInf_model}
}
