% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{quiet}
\alias{quiet}
\title{Suppress verbose function messages}
\usage{
quiet(..., cat = TRUE, keep = FALSE, attr.name = "quiet.messages")
}
\arguments{
\item{...}{the functional expression to be evaluated}

\item{cat}{logical; also capture calls from \code{\link{cat}}? If
\code{FALSE} only \code{\link{message}} will be suppressed}

\item{keep}{logical; return a character vector of the messages/concatenate
and print strings as an attribute to the resulting object from \code{expr(...)}?}

\item{attr.name}{attribute name to use when \code{keep = TRUE}}
}
\description{
This function is used to suppress information printed from external functions
that make internal use of \code{link{message}} and \code{\link{cat}}, which
provide information in interactive R sessions. For simulations, the session
is not interactive, and therefore this type of output should be suppressed.
For similar behaviour for suppressing warning messages, see
\code{link{manageWarnings}}.
}
\examples{

myfun <- function(x, warn=FALSE){
   message('This function is rather chatty')
   cat("It even prints in different output forms!\n")
   message('And even at different....')
   cat("...times!\n")
   if(warn)
     warning('It may even throw warnings!')
   x
}

out <- myfun(1)
out

# tell the function to shhhh
out <- quiet(myfun(1))
out

# which messages are suppressed? Extract stored attribute
out <- quiet(myfun(1), keep = TRUE)
attr(out, 'quiet.messages')

# Warning messages still get through (see manageWarnings(suppress)
#  for better alternative than using suppressWarnings())
out2 <- myfun(2, warn=TRUE) |> quiet() # warning gets through
out2

# suppress warning message explicitly, allowing others to be raised if present
myfun(2, warn=TRUE) |> quiet() |>
   manageWarnings(suppress='It may even throw warnings!')

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{manageWarnings}}
}
