% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{quiet}
\alias{quiet}
\title{Suppress function messages and Concatenate and Print (cat)}
\usage{
quiet(..., messages = FALSE, cat = FALSE)
}
\arguments{
\item{...}{the functional expression to be evaluated}

\item{messages}{logical; suppress all messages?}

\item{cat}{logical; suppress all concatenate and print calls from \code{\link{cat}}?}
}
\description{
This function is used to suppress information printed from external functions
that make internal use of \code{link{message}} and \code{\link{cat}}, which
provide information in interactive R sessions. For simulations, the session
is not interactive, and therefore this type of output should be suppressed.
For similar behaviour for suppressing warning messages see
\code{\link{suppressWarnings}}, though use this function carefully as some
warnings can be meaningful and unexpected.
}
\examples{
myfun <- function(x){
   message('This function is rather chatty')
   cat("It even prints in different output forms!\n")
   message('And even at different....')
   cat("...times!\n")
   x
}

out <- myfun(1)
out

# tell the function to shhhh
out <- quiet(myfun(1))
out

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
