% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{MAE}
\alias{MAE}
\title{Compute the mean absolute error}
\usage{
MAE(estimate, parameter = NULL, type = "MAE")
}
\arguments{
\item{estimate}{a \code{numeric} vector or \code{matrix}/\code{data.frame} of parameter estimates.
If a vector, the length is equal to the number of replications. If a
\code{matrix}/\code{data.frame} the number of rows must equal the number of replications}

\item{parameter}{a \code{numeric} scalar/vector indicating the fixed parameter values.
If a single value is supplied and \code{estimate} is a \code{matrix}/\code{data.frame} then the value will be
recycled for each column.
If \code{NULL}, then it will be assumed that the \code{estimate} input is in a deviation
form (therefore \code{mean(abs(estimate))} will be returned)}

\item{type}{type of deviation to compute. Can be \code{'MAE'} (default) for the mean absolute error,
\code{'NMSE'} for the normalized MAE (MAE / (max(estimate) - min(estimate))), or
\code{'NMSE_SD'} for the normalized MAE by the standard deviation (MAE / sd(estimate)),}
}
\value{
returns a numeric vector indicating the overall mean absolute error in the estimates
}
\description{
Computes the average absolute deviation of a sample estimate from the parameter value.
Accepts estimate and parameter values, as well as estimate values which are in deviation form.
}
\examples{

pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
MAE(samp, pop)

dev <- samp - pop
MAE(dev)
MAE(samp, pop, type = 'NMAE')
MAE(samp, pop, type = 'NMAE_SD')

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
MAE(mat, parameter = 2)

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
MAE(df, parameter = c(2,2))

# parameters of the same size
parameters <- 1:10
estimates <- parameters + rnorm(10)
MAE(estimates, parameters)

}
\seealso{
RMSE
}
