% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimFunctions.R
\name{SimFunctions}
\alias{SimDesign_functions}
\alias{SimFunctions}
\title{Skeleton functions for simulations}
\usage{
SimFunctions(filename = NULL, comments = TRUE, singlefile = FALSE)

SimDesign_functions(filename = NULL, comments = TRUE, singlefile = FALSE)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{comments}{logical; include helpful comments? Default is \code{TRUE}}

\item{singlefile}{logical; when \code{filename} is included, put output in one files? When \code{FALSE} the
output is saved to two separate files containing the functions and design definitions. Default is
\code{FALSE}}
}
\description{
This function prints skeleton versions of the required functions and work-flow required
to run simulations, complete with the correct inputs, class of outputs, and option comments to
help with the initial definitions. Use this at the start
when defining your simulation.
}
\details{
The function \code{SimDesign_functions} is deprecated and will be
removed in a future release.
}
\examples{

SimFunctions()
SimFunctions(comments=FALSE) #without comments

\dontrun{

# write output to two files
SimFunctions('mysim')

# write output files to a single file without comments
SimFunctions('mysim', comments = FALSE, singlefile = TRUE)
}

}

