% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{MAE}
\alias{MAE}
\title{Compute the mean absolute error}
\usage{
MAE(observed, population = NULL, type = "MAE")
}
\arguments{
\item{observed}{a numeric vector of parameter estimates, where the length is equal to the number of
  replications}

\item{population}{a numeric scalar indicating the fixed population value. If NULL, then it will be assumed
  that the \code{observed} input is in a deviation form (therefore \code{mean(abs(observed))} will be
  returned)}

\item{type}{type of deviation to compute. Can be 'MAE' (default) for the mean absolute error, or
  'NMSE' for the normalized MAE (MAE / (max(observed) - min(observed)))}
}
\value{
returns a single number indicating the overall mean absolute error in the estimates
}
\description{
Computes the average absolute deviation of a sample estimate from the population value.
Accepts observed and population values,
as well as observed values which are in deviation form.
}
\examples{
pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
MAE(samp, pop)

dev <- samp - pop
MAE(dev)
MAE(samp, pop, type = 'NMAE')
}
\seealso{
RMSE
}

