% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SignacBoot}
\alias{SignacBoot}
\title{Generates bootstrapped single cell data}
\usage{
SignacBoot(
  E,
  L,
  labels,
  size = 1000,
  impute = TRUE,
  spring.dir = NULL,
  logfc.threshold = 0.25,
  p.val.adj = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{E}{a gene (rows) by cell (column) matrix, sparse matrix or a Seurat object. Rows are HUGO symbols.}

\item{L}{cell type categories for learning.}

\item{labels}{cell type labels corresponding to the columns of E.}

\item{size}{Number of bootstrapped samples for machine learning. Default is 1,000.}

\item{impute}{if TRUE, performs imputation prior to bootstrapping (see \code{\link{KSoftImpute}}). Default is TRUE.}

\item{spring.dir}{if using SPRING, directory to categorical_coloring_data.json. Default is NULL.}

\item{logfc.threshold}{Cutoff for feature selection. Default is 0.25.}

\item{p.val.adj}{Cutoff for feature selection. Default is 0.05.}

\item{verbose}{if TRUE, code speaks. Default is TRUE.}
}
\value{
Training data set (data.frame) to be used for building new models=.
}
\description{
\code{SignacBoot} uses a Seurat object or an expression matrix and performs feature selection, normalization and bootstrapping
to generate a training data set to be used for cell type or cluster classification.
}
\examples{
\dontrun{
# load Seurat object from SignacFast example
P <- readRDS("pbmcs.rds")

# run feature selection + bootstrapping to generate 2,000 bootstrapped cells
x = P@meta.data$celltypes
R_learned = SignacBoot(P, L = c("B.naive", "B.memory"), labels = x)
}
}
\seealso{
\code{\link{ModelGenerator}}
}
