% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoosePopR_DomStrat_bootrep.R
\name{MoosePopR_DomStrat_bootrep}
\alias{MoosePopR_DomStrat_bootrep}
\title{Generate a bootstrap replicate of data for call to MoosePopR_DomStrat()}
\usage{
MoosePopR_DomStrat_bootrep(
  stratum.data,
  selected.unit.data,
  waypoint.data,
  density = NULL,
  abundance = NULL,
  numerator = NULL,
  denominator = NULL,
  sight.model = NULL,
  sight.beta = NULL,
  sight.beta.cov = NULL,
  stratum.var = "Stratum",
  domain.var = "Domain",
  stratum.total.blocks.var = "Total.Blocks",
  stratum.total.area.var = "Total.Area",
  block.id.var = "Block.ID",
  block.area.var = "Block.Area",
  conf.level = 0.9,
  survey.lonely.psu = "fail",
  check.args = TRUE
)
}
\arguments{
\item{stratum.data}{A data frame containing for each combination of stratum and domain, the stratum id (see stratum.var), 
the domain id (see domain.var),
the total number of blocks in the stratum (see stratum.total.blocks.var) and 
the total area of the stratum (see stratum.total.area.var)}

\item{selected.unit.data}{A data frame containing information on the selected survey units. Required variables
are the stratum (see stratum.var), domain (see domain.var), block.id (see block.id.var), and the
   area of the block (see block.area.var).}

\item{waypoint.data}{A data frame containing counts of moose in each group along with a variable identifying 
the stratum (see stratum.var), domain (see domain.var) and block (see block.id.var). Additional variables can
be included such as covariates for the sightability function (not currently used in MoosePopR)}

\item{density, abundance, numerator, denominator}{Right-handed formula identifying the variable(s) in the
waypoint data frame for which the density, abundance, or ratio (numerator/denominator) are to be estimated.}

\item{sight.model}{A formula that identifies the model used
to estimate sightability. For example \code{observed ~ VegCoverClass} would indicate
that sightability is a function of the \code{VegCoverClass} variable in the survey 
data. The left hand variable is arbitrary. The right hand variables must be present
in the survey.data data frame.}

\item{sight.beta}{The vector of estimated coefficients for the logistic regression sightability model.}

\item{sight.beta.cov}{The covariance matrix of \code{sight.beta}}

\item{stratum.var}{Name of the variable in the data frames that identifies the classical stratum}

\item{domain.var}{Name of the variable in the data frames that identifies the domain.}

\item{stratum.total.blocks.var}{Name of the variable in the stratum.data data frame that contains the total number of
blocks in the stratum.}

\item{stratum.total.area.var}{Name of the variable in the stratum.data data.frame that contains the total stratum area.}

\item{block.id.var}{Name of the variable in the data frames that identifies the block.id (the sampling unit)}

\item{block.area.var}{Name of the variable in data frames that contains the area of the blocks (area of sampling unit)}

\item{conf.level}{Confidence level used to create confidence intervals.}

\item{survey.lonely.psu}{How to deal with lonely PSU within strata. See \code{surveyoptions} in the \code{survey} package.}

\item{check.args}{Should arguments be checked. Turn off for extensive bootstrapping to save time.}
}
\value{
A list containing the input data (\code{input.data}), 
the bootstrap replicate (\code{boot.data}), and a data frame (\code{boot.res}) with the estimated density,
   or abundance or ratio along with its estimated standard error and large-sample normal-based confidence interval.
   The density/abundance/ratio over all strata is also given on the last line of the data.frame.
}
\description{
This function takes the data from a classical/domain stratification and generates
a bootstrap replicate suitable for analysis using MoosePopR_DomStrat().
A sightability model is allowed which "adjusts" the input data for sightability.
This can also be used for SightabilityPopR() models by forcing block areas to 1 and
the total block area in stratum to the number of blocks to mimic a mean-per-unit estimator.
See the vignette for examples of usage.
}
\examples{
 
##---- See the vignettes for examples on how to use this function

}
\references{
To Be Added.
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{surveys}
\keyword{~MOOSEPOP}
\keyword{~moose}
