% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.functions.R
\name{make.polynomial.decay}
\alias{make.polynomial.decay}
\title{Make a polynomial decay function}
\usage{
make.polynomial.decay(threshold, degree = 1)
}
\arguments{
\item{threshold}{A numeric denoting how quickly the polynomial function decays. Distances greater than the threshold will return a success probability of 0.}

\item{degree}{The degree of the polynomial}
}
\value{
An polynomial decay function
}
\description{
Create a polynomial decay function for genetic distance of two taxa and the probability of success of a hybridization event
}
\details{
The function computes: \deqn{1- {\frac{d}{t}}^degree}{1-((d/t)^degree)}
Where d is the distance and t is the threshold
}
\examples{
set.seed(17)
dist_func<- make.polynomial.decay(0.5,2)
net<-sim.bdh.age(1,1,5,2,2,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),
hyb.rate.fxn=dist_func,complete=TRUE)[[1]]
}
