% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antcolony_plot.R
\name{antcolony_plot}
\alias{antcolony_plot}
\title{ACO Plot Function}
\usage{
antcolony_plot(results, verbose = FALSE, ...)
}
\arguments{
\item{results}{The output from `antcolony.lavaan`.}

\item{verbose}{Logical. If true, prints the warnings and errors from `ggplot2`
regarding the plots being created. Defaults to `FALSE`.}

\item{...}{Other arguments to be passed to the `ggplot2` functions. Currently
unimplemented.}
}
\value{
A list of three plots: 
\describe{
\item{1}{A pheromone plot, showing how the pheromone levels for each item change 
for each run of the algorithm;}
\item{2}{A mean gamma plot, showing a loess smoothing plot of changes in the mean
gamma (regression coefficients) of the best-fit model for each run of the 
algorithm;}
\item{3}{A mean variance explained plot, showing a loess smoothing plot of 
changes in the mean variance explained of the best-fit model for each run of the 
algorithm}
}
}
\description{
ACO Plot Function
}
\examples{
\dontrun{
# Below is a modified version of the example in the `antcolony.lavaan` function.
# The latent variables are allowed to be correlated for identification
results = antcolony.lavaan(data = lavaan::HolzingerSwineford1939,
ants = 5, evaporation = 0.7, 
antModel = ' visual  =~ x1 + x2 + x3
             textual =~ x4 + x5 + x6
             speed   =~ x7 + x8 + x9 
             visual ~ textual + speed
             textual ~ speed', 
list.items = list(c('x1', 'x2', 'x3'), 
                  c('x4', 'x5', 'x6'), 
                  c('x7', 'x8', 'x9')), 
                  full = 9, i.per.f = c(2,2,2), 
                  factors = c('visual','textual','speed'), 
                  steps = 10, fit.indices = c('cfi'), 
                  fit.statistics.test = "(cfi > 0.6)", 
                  summaryfile = NULL, feedbackfile = NULL, max.run = 100)

# once converged, put the entire results object into the antcolony_plot function:
plots <- antcolony_plot(results)

# print the plot for changes in mean gamma
plots[[2]]

}
}
