% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistractorAnalysis.R
\name{plotDistractorAnalysis}
\alias{plotDistractorAnalysis}
\title{Function for graphical representation of item distractor analysis}
\usage{
plotDistractorAnalysis(data, key, num.groups = 3, item = 1, item.name,
multiple.answers = TRUE, matching = NULL, match.discrete = FALSE, cut.points)
}
\arguments{
\item{data}{character: data matrix or data frame. See \strong{Details}.}

\item{key}{character: answer key for the items.}

\item{num.groups}{numeric: number of groups to that should be respondents splitted.}

\item{item}{numeric: the number of item to be plotted.}

\item{item.name}{character: the name of item.}

\item{multiple.answers}{logical: should be all combinations plotted (default) or should be
answers splitted into distractors. See \strong{Details}.}

\item{matching}{numeric: numeric vector. If not provided, total score is calculated and
distractor analysis is performed based on it.}

\item{match.discrete}{logical: is \code{matching} discrete? Default value is \code{FALSE}. See details.}

\item{cut.points}{numeric: numeric vector specifying cut points of \code{matching}. See details.}
}
\description{
Plots graphical representation of item distractor analysis with proportions and
optional number of groups.
}
\details{
This function is graphical representation of \code{\link{DistractorAnalysis}} function.
In case, no \code{matching} is provided, the scores are calculated using the item data and key.
The respondents are by default splitted into the \code{num.groups}-quantiles and the proportions
of respondents in each quantile are displayed with respect to their answers. In case that \code{matching}
is discrete (\code{match.discrete = TRUE}), \code{matching} is splitted based on its unique levels. Other
cut points can be specified via \code{cut.points} argument.

The \code{data} is a matrix or data frame whose rows represents unscored item response from a
multiple-choice test and columns correspond to the items.

The \code{key} must be a vector of the same length as \code{ncol(data)}. In case it is not provided,
\code{matching} need to be specified.

If \code{multiple.answers = TRUE} (default) all reported combinations of answers are plotted.
If \code{multiple.answers = FALSE} all combinations are splitted into distractors and only these
are then plotted with correct combination.
}
\examples{

# loading 100-item medical admission test data
data(dataMedical, dataMedicaltest, dataMedicalkey)
data <- dataMedicaltest[, 1:100]
dataBin <- dataMedical[, 1:100]
key <- unlist(dataMedicalkey)

# distractor plot for items 48, 57 and 32 displaying distractors only
plotDistractorAnalysis(data, key, item = 48, multiple.answers = FALSE)
# correct answer B does not function well
plotDistractorAnalysis(data, key, item = 57, multiple.answers = FALSE)
# all options function well, thus the whole item discriminates well
plotDistractorAnalysis(data, key, item = 32, multiple.answers = FALSE)
# functions well, thus the whole item discriminates well
\dontrun{
# distractor plot for items 48, 57 and 32 displaying all combinations
plotDistractorAnalysis(data, key, item = 48)
plotDistractorAnalysis(data, key, item = 57)
plotDistractorAnalysis(data, key, item = 32)

# distractor plot for item 57 with all combinations and 6 groups
plotDistractorAnalysis(data, key, item = 57, num.group = 6)

# distractor plot for item 57 using specified matching and key option
matching <- round(rowSums(dataBin), -1)
plotDistractorAnalysis(data, key, item = 57, matching = matching)
# distractor plot for item 57 using specified matching without key option
plotDistractorAnalysis(data, item = 57, matching = matching)

# distractor plot for item 57 using discrete matching
plotDistractorAnalysis(data, key, item = 57, matching = matching, match.discrete = T)

# distractor plot for item 57 using groups specified by cut.points
plotDistractorAnalysis(data, key, item = 57, cut.points = seq(10, 100, 10))
}
}
\seealso{
\code{\link{DistractorAnalysis}}, \code{\link[CTT]{distractor.analysis}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
